/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.humanoid;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByProfession;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.jobs.model.Profession;

public class HumanoidEntityAssetsByGender {
    private Map<Gender, HumanoidEntityAssetsByProfession> genderMap = new EnumMap<Gender, HumanoidEntityAssetsByProfession>(Gender.class);

    public HumanoidEntityAssetsByGender() {
        for (Gender type : Gender.values()) {
            this.genderMap.put(type, new HumanoidEntityAssetsByProfession());
        }
    }

    public void add(HumanoidEntityAsset asset) {
        Gender gender = asset.getGender();
        if (gender == null || gender.equals((Object)Gender.ANY)) {
            for (HumanoidEntityAssetsByProfession assetsByProfession : this.genderMap.values()) {
                assetsByProfession.add(asset);
            }
        } else {
            this.genderMap.get((Object)gender).add(asset);
            this.genderMap.get((Object)Gender.ANY).add(asset);
        }
    }

    public HumanoidEntityAsset get(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        Gender entityGender = attributes.getGender();
        if (entityGender == null) {
            entityGender = Gender.ANY;
        }
        return this.genderMap.get((Object)entityGender).get(attributes, primaryProfession);
    }

    public List<HumanoidEntityAsset> getAll(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        Gender entityGender = attributes.getGender();
        if (entityGender == null) {
            entityGender = Gender.ANY;
        }
        return this.genderMap.get((Object)entityGender).getAll(attributes, primaryProfession);
    }
}

